#include <iostream>
#include <vector>
#include <set>
#include <deque>
#include <stack>
#include <queue>
#include <map>
#include <unordered_map>
#include <unordered_set>
#include <iomanip>
#include <random>
#include <algorithm>
#include <cmath>
#include <fstream>

using namespace std;

typedef long long ll;
typedef long double dl;

ll power(ll a, ll p, ll mod)
{
	if (a == 0) return 1;
	if (a == 1) return a;
	ll d = power(a, p / 2, mod);
	if (p & 1) return ((d * d) % mod * a) % mod;
	return (d * d) % mod;
}
ll gcd(ll a, ll b)
{
	if (a == 0 || b == 0) return a + b;
	if (a > b) return gcd(a % b, b);
	return gcd(a, b % a);
}
ll get_hash(ll l, ll r, vector <ll>& h, vector <ll>& p, ll mod)
{
	return ((h[r + 1] - p[r - l + 1] * h[l]) % mod + mod) % mod;
}
ll find(ll v, vector <ll>& p)
{
	if (p[v] == v) return v;
	return p[v] = find(p[v], p);
}
void union_s(ll a, ll b, vector <ll>& p, vector <ll>& sz)
{
	a = find(a, p);
	b = find(b, p);
	if (a != b)
	{
		if (sz[a] < sz[b]) swap(a, b);
		p[b] = a;
		sz[a] += sz[b];
	}
}
ll timer = 0;
void dfs(ll v, ll prev, vector <ll>& tin, vector <ll>& tout, vector <vector <ll>>& up, vector <vector <ll>>& g)
{
	tin[v] = timer++;
	up[0][v] = prev;
	for (ll i = 1; i < up.size(); i++)
	{
		up[i][v] = up[i - 1][up[i - 1][v]];
	}
	for (auto i : g[v])
	{
		if (i != prev)
		{
			dfs(i, v, tin, tout, up, g);
		}
	}
	tout[v] = timer++;
}
bool upper(ll a, ll b, vector <ll>& tin, vector <ll>& tout)
{
	return tin[a] <= tin[b] && tout[b] <= tout[a];
}
ll lca(ll a, ll b, vector <ll>& tin, vector <ll>& tout, vector <vector <ll>>& up)
{
	if (upper(a, b, tin, tout)) return a;
	if (upper(b, a, tin, tout)) return b;
	for (ll i = up.size() - 1; i >= 0; i--)
	{
		if (!upper(up[i][a], b, tin, tout))
		{
			a = up[i][a];
		}
	}
	return up[0][a];
}


int main()
{
	//ifstream cin("input.txt");
	//ofstream cout("output.txt");
	cin.tie(0);
	cout.tie(0);
	ios_base::sync_with_stdio(0);
	//random_device rd;
	//mt19937 gen(rd());
	
	ll t;
	cin >> t;
	while (t--)
	{
		ll w0, h0, w, h, x, y;
		cin >> w0 >> h0 >> w >> h >> x >> y;
		ll ans = 0;
		ans += ((x + w - 1) / w) * ((y + h - 1) / h);
		ans += ((w0 - x + w - 1) / w) * ((y + h - 1) / h);
		ans += ((w0 - x + w - 1) / w) * ((h0 - y + h - 1) / h);
		ans += ((x + w - 1) / w) * ((h0 - y + h - 1) / h);
		cout << ans - 1 << "\n";
	}

	return 0;
}